IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Act_Precios_Refe_Present') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].CP_Act_Precios_Refe_Present 
END
GO


CREATE PROCEDURE [dbo].[CP_Act_Precios_Refe_Present]  
AS
SET NOCOUNT ON


BEGIN TRY 
BEGIN TRAN

	    SELECT l.Id_Lista_Precio,P.ID_PRODUCTO, ISNULL(L.PRECIO,0)*(1-(ISNULL(PR.Porc_Act_Precio,0)/100)) as Precio
			INTO #nuevo_precio
			FROM Prod_Listas_Precios_Items L, Productos P, Prod_Present PR, PRODUCTOS PP, Prod_Listas_Precios LP
			WHERE  P.Id_Producto_Padre = PP.Id_Producto
					AND PP.Id_Present = PR.Id_Present
					AND L.Id_Producto = P.Id_Producto_padre
					AND LP.Id_Lista_Precio = L.Id_Lista_Precio
					AND LP.ACTIVO = 1

		UPDATE Prod_Listas_Precios_Items set Precio = P.precio 
			FROM #nuevo_precio P, Prod_Listas_Precios_Items l
			WHERE p.Id_Lista_Precio = l.Id_Lista_Precio
			AND p.Id_Producto = l.Id_Producto

		DROP TABLE #nuevo_precio
		COMMIT

    	SELECT	 0							AS ErrorNumber 
			,0								AS ErrorSeverity  
			,0								AS ErrorState 
			,0								AS ErrorProcedure  
			,0	                            AS ErrorLine		
			,''								AS ErrorMessage

END TRY 

BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 